#include "General.h"
#include "derp.h"
#include "HashTemplateClass.h"
#include "HashTemplateIterator.h"

// This macro creates a new Class on the heap and cals Startup for it
#define REGISTER_COMMAND(Class, Trigger, registrant) Class *registrant = new Class; registrant->Startup(Trigger)

HashTemplateClass<StringClass, ChatCommand *> ChatCommand::CommandsMap;

void ChatCommand::Load()
{
	REGISTER_COMMAND(Help, "!help", Help_Registrant); // Registers a new Help ChatCommand objectcalled with !help
	REGISTER_COMMAND(Help, "!h", HelpAlias_Registrant); // Registers a new Help ChatCommand object called with !h
}

void ChatCommand::Unload()
{
}

// This simply adds the command to our CommandsMap with the trigger, it can later be expanded to do more
void ChatCommand::Startup(const char* Trigger)
{
	ChatCommand::CommandsMap.Insert(Trigger, this); // 'this' is a pointer to the current class
}

// This is a virtual method, this is used for the default for classes that don't have the Activate() method
void ChatCommand::Activate(int ID, int Type, StringClass Msg)
{
	Console("MSG this command hasn't been implemented yet");
}

// This is the only thing we nee to implement for a new class inheriting from ChatCommand
void Help::Activate(int ID, int Type, StringClass Msg)
{
	Console("MSG This is a fancy help command!");
}

// Example chat hook code to get the above to work
bool KamBot::OnChat(int PlayerID, TextMessageEnum Type, const wchar_t *Message, int recieverID)
{
	StringClass Msg = Message;

	if (ChatCommand::CommandsMap.Exists(Message)) // Does our hash map contain a trigger that is the same as the input message?
	{ // If so
		ChatCommand* c = ChatCommand::CommandsMap.Get(Message, 0); // Get the ChatCommand pointer that's indexed for the chat message
		c->Activate(PlayerID, Type, Msg); // With our ChatCommand pointer called 'c', call the Activate() function
	}

	return true;
}